/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.annotation;

import java.lang.annotation.Annotation;
import org.javers.common.collections.Optional;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.annotation.AnnotationNamesProvider;
import org.javers.core.metamodel.annotation.ClassAnnotationsScan;

public class ClassAnnotationsScanner {
    private final AnnotationNamesProvider annotationNamesProvider;

    public ClassAnnotationsScanner(AnnotationNamesProvider annotationNamesProvider) {
        this.annotationNamesProvider = annotationNamesProvider;
    }

    public ClassAnnotationsScan scan(Class javaClass) {
        Validate.argumentIsNotNull(javaClass);
        Optional<String> typeName = Optional.empty();
        for (Annotation ann : javaClass.getAnnotations()) {
            if (!this.annotationNamesProvider.isTypeName(ann)) continue;
            typeName = Optional.of((String)ReflectionUtil.invokeGetter(ann, "value"));
        }
        boolean hasValue = false;
        boolean hasValueObject = false;
        boolean hasEntity = false;
        for (Annotation ann : javaClass.getAnnotations()) {
            if (this.annotationNamesProvider.isEntityAlias(ann)) {
                hasEntity = true;
            }
            if (this.annotationNamesProvider.isValueAlias(ann)) {
                hasValue = true;
            }
            if (!this.annotationNamesProvider.isValueObjectAlias(ann)) continue;
            hasValueObject = true;
        }
        return new ClassAnnotationsScan(hasValue, hasValueObject, hasEntity, typeName);
    }
}

