/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.HashSet;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.snapshot.ShadowGraph;
import org.javers.repository.api.JaversExtendedRepository;

class GraphShadowFactory {
    private final JaversExtendedRepository javersRepository;

    GraphShadowFactory(JaversExtendedRepository javersRepository) {
        this.javersRepository = javersRepository;
    }

    ShadowGraph createLatestShadow(LiveGraph liveGraph) {
        Validate.argumentIsNotNull(liveGraph);
        HashSet<ObjectNode> snapshotNodes = new HashSet<ObjectNode>();
        for (ObjectNode liveNode : liveGraph.nodes()) {
            Optional<CdoSnapshot> snapshot = this.javersRepository.getLatest(liveNode.getGlobalId());
            if (snapshot.isEmpty()) continue;
            snapshotNodes.add(new ObjectNode(snapshot.get()));
        }
        return new ShadowGraph(snapshotNodes);
    }
}

