/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.MapEnumeratorContext;

public class MapType
extends EnumerableType {
    public MapType(Type baseJavaType) {
        super(baseJavaType);
    }

    @Override
    public boolean isFullyParametrized() {
        return this.getActualTypeArguments().size() == 2;
    }

    @Override
    public Map map(Object sourceMap_, EnumerableFunction mapFunction, OwnerContext owner) {
        return MapType.mapStatic(sourceMap_, mapFunction, owner);
    }

    public static Map mapStatic(Object sourceMap_, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentIsNotNull(mapFunction);
        if (sourceMap_ == null) {
            return Collections.EMPTY_MAP;
        }
        Map sourceMap = (Map)sourceMap_;
        HashMap targetMap = new HashMap(sourceMap.size());
        MapEnumeratorContext enumeratorContext = new MapEnumeratorContext();
        owner.setEnumeratorContext(enumeratorContext);
        for (Map.Entry entry : sourceMap.entrySet()) {
            enumeratorContext.switchToKey();
            Object mappedKey = mapFunction.apply(entry.getKey(), owner);
            enumeratorContext.switchToValue(mappedKey);
            Object mappedValue = mapFunction.apply(entry.getValue(), owner);
            targetMap.put(mappedKey, mappedValue);
        }
        return Collections.unmodifiableMap(targetMap);
    }

    @Override
    public boolean isEmpty(Object map) {
        return map == null || ((Map)map).isEmpty();
    }

    public Type getKeyType() {
        if (this.isFullyParametrized()) {
            return this.getActualTypeArguments().get(0);
        }
        throw new JaversException(JaversExceptionCode.GENERIC_TYPE_NOT_PARAMETRIZED, this.getBaseJavaType().toString());
    }

    public Type getValueType() {
        if (this.isFullyParametrized()) {
            return this.getActualTypeArguments().get(1);
        }
        throw new JaversException(JaversExceptionCode.GENERIC_TYPE_NOT_PARAMETRIZED, this.getBaseJavaType().toString());
    }
}

