/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.List;
import org.javers.common.collections.Function;
import org.javers.common.collections.Lists;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ParametrizedDehydratedType;
import org.javers.core.metamodel.type.TypeMapper;

class DehydratedTypeBuilder {
    private TypeMapper mapper;

    DehydratedTypeBuilder(TypeMapper mapper) {
        this.mapper = mapper;
    }

    public Type build(Type forType) {
        JaversType javersType = this.mapper.getJaversType(forType);
        if (!javersType.isGenericType()) {
            return javersType.getRawDehydratedType();
        }
        Class rawType = javersType.getBaseJavaClass();
        List<Type> actualDehydratedTypeArguments = this.extractAndDehydrateTypeArguments(javersType);
        return new ParametrizedDehydratedType(rawType, actualDehydratedTypeArguments);
    }

    private List<Type> extractAndDehydrateTypeArguments(JaversType genericType) {
        return Lists.transform(genericType.getActualTypeArguments(), new Function<Type, Type>(){

            @Override
            public Type apply(Type typeArgument) {
                return DehydratedTypeBuilder.this.build(typeArgument);
            }
        });
    }
}

