/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.common.collections.Defaults;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.Property;

public class CdoSnapshotState {
    private final Map<Property, Object> properties;

    CdoSnapshotState(Map<Property, Object> state) {
        Validate.argumentIsNotNull(state);
        this.properties = state;
    }

    int size() {
        return this.properties.size();
    }

    public Object getPropertyValue(Property property) {
        Validate.argumentIsNotNull(property);
        Object val = this.properties.get(property);
        if (val == null) {
            return Defaults.defaultValue(property.getType());
        }
        return val;
    }

    boolean isNull(Property property) {
        Validate.argumentIsNotNull(property);
        return !this.properties.containsKey(property);
    }

    public Set<Property> getProperties() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CdoSnapshotState)) {
            return false;
        }
        CdoSnapshotState that = (CdoSnapshotState)o;
        if (this.properties.size() != that.properties.size()) {
            return false;
        }
        for (Property p : this.properties.keySet()) {
            if (this.propertyEquals(that, p)) continue;
            return false;
        }
        return true;
    }

    private boolean propertyEquals(CdoSnapshotState that, Property property) {
        Object thisValue = this.getPropertyValue(property);
        Validate.conditionFulfilled(thisValue != null, "null value at CdoCnapshot property " + property.getName());
        Object thatValue = that.getPropertyValue(property);
        if (property.getType().isArray()) {
            return Arrays.equals((Object[])thisValue, (Object[])thatValue);
        }
        return thisValue.equals(thatValue);
    }

    public List<Property> differentValues(CdoSnapshotState previous) {
        ArrayList<Property> different = new ArrayList<Property>();
        for (Property property : this.properties.keySet()) {
            if (this.propertyEquals(previous, property)) continue;
            different.add(property);
        }
        return different;
    }

    public int hashCode() {
        return this.properties.hashCode();
    }
}

