/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;

public abstract class ContainerChange
extends PropertyChange {
    private final List<ContainerElementChange> changes;

    ContainerChange(GlobalId affectedCdoId, Property property, List<ContainerElementChange> changes) {
        super(affectedCdoId, property);
        Validate.argumentIsNotNull(changes);
        Validate.argumentCheck(!changes.isEmpty(), "changes list should not be empty");
        this.changes = Collections.unmodifiableList(new ArrayList<ContainerElementChange>(changes));
    }

    public List<ContainerElementChange> getChanges() {
        return this.changes;
    }

    @Override
    protected String fieldsToString() {
        StringBuilder changesAsString = new StringBuilder();
        for (ContainerElementChange c : this.changes) {
            if (changesAsString.length() > 0) {
                changesAsString.append(", ");
            }
            changesAsString.append(c);
        }
        return super.fieldsToString() + ToStringBuilder.addEnumField("containerChanges", changesAsString);
    }
}

