/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Optional;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.collections.Function;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.CollectionType;

public class OptionalType
extends CollectionType {
    public OptionalType(Type baseJavaType) {
        super(baseJavaType);
    }

    public OptionalType() {
        super((Type)((Object)Optional.class));
    }

    @Override
    public boolean isFullyParametrized() {
        return this.getActualTypeArguments().size() == 1;
    }

    @Override
    public Object map(Object sourceOptional_, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentsAreNotNull(sourceOptional_, mapFunction);
        Optional sourceOptional = this.toNormalizedOptional(sourceOptional_);
        if (!sourceOptional.isPresent()) {
            return Optional.empty();
        }
        Object applied = mapFunction.apply(sourceOptional.get(), owner);
        return Optional.of(applied);
    }

    @Override
    public boolean isEmpty(Object optional) {
        return optional == null || !this.toNormalizedOptional(optional).isPresent();
    }

    private Object get(Object sourceOptional_) {
        Optional sourceOptional = this.toNormalizedOptional(sourceOptional_);
        if (sourceOptional.isPresent()) {
            return sourceOptional.get();
        }
        return null;
    }

    public Object mapAndGet(Object sourceOptional, Function mapFunction) {
        return mapFunction.apply(this.get(sourceOptional));
    }

    public Object normalize(Object sourceOptional) {
        if (sourceOptional == null) {
            return Optional.empty();
        }
        return sourceOptional;
    }

    private Optional toOptional(Object optional) {
        if (!(optional instanceof Optional)) {
            throw new JaversException(JaversExceptionCode.RUNTIME_EXCEPTION, "instance of Optional expected");
        }
        return (Optional)optional;
    }

    private Optional toNormalizedOptional(Object optional) {
        return (Optional)this.normalize(this.toOptional(optional));
    }
}

