/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;

public class InstanceId
extends GlobalId {
    private final transient EntityType entity;
    private final Object cdoId;

    private InstanceId(Object cdoId, EntityType entity) {
        Validate.argumentsAreNotNull(cdoId, entity);
        this.entity = entity;
        this.cdoId = cdoId;
    }

    public static InstanceId createFromInstance(Object instance, EntityType entity) {
        return new InstanceId(entity.getIdOf(instance), entity);
    }

    public static InstanceId createFromId(Object id, EntityType entity) {
        return new InstanceId(id, entity);
    }

    @Override
    public EntityType getManagedType() {
        return this.entity;
    }

    @Override
    public Object getCdoId() {
        return this.cdoId;
    }

    @Override
    public String value() {
        return this.entity.getName() + "/" + this.getCdoIdAsString();
    }

    public boolean idEquals(Object instance) {
        if (instance == null) {
            return false;
        }
        if (!this.entity.isInstance(instance)) {
            return false;
        }
        return this.cdoId.equals(this.entity.getIdOf(instance));
    }

    private String getCdoIdAsString() {
        return ReflectionUtil.reflectiveToString(this.cdoId);
    }
}

