/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.javers.common.collections.Function;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.property.Property;

public final class CdoSnapshot
extends Cdo {
    private CommitMetadata commitMetadata;
    private final CdoSnapshotState state;
    private final SnapshotType type;
    private final List<Property> changed;

    CdoSnapshot(GlobalId globalId, CommitMetadata commitMetadata, CdoSnapshotState state, SnapshotType type, List<Property> changed) {
        super(globalId);
        Validate.argumentsAreNotNull(new Object[]{state, commitMetadata, type});
        this.state = state;
        this.commitMetadata = commitMetadata;
        this.type = type;
        this.changed = changed;
    }

    @Override
    public Optional<Object> getWrappedCdo() {
        return Optional.empty();
    }

    public int size() {
        return this.state.size();
    }

    @Override
    public Object getPropertyValue(Property property) {
        return this.state.getPropertyValue(property);
    }

    public List<Property> getChanged() {
        return Collections.unmodifiableList(this.changed);
    }

    public List<String> getChangedPropertyNames() {
        return Lists.transform(this.getChanged(), new Function<Property, String>(){

            @Override
            public String apply(Property input) {
                return input.getName();
            }
        });
    }

    public boolean hasChangeAt(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        for (Property p : this.changed) {
            if (!p.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getPropertyValue(String withName) {
        Property property = this.getGlobalId().getManagedType().getProperty(withName);
        return this.getPropertyValue(property);
    }

    @Override
    public boolean isNull(Property property) {
        return this.state.isNull(property);
    }

    public CommitId getCommitId() {
        return this.commitMetadata.getId();
    }

    public CommitMetadata getCommitMetadata() {
        return this.commitMetadata;
    }

    public boolean stateEquals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdoSnapshot other = (CdoSnapshot)o;
        return this.state.equals(other.state);
    }

    public Set<Property> getProperties() {
        return this.state.getProperties();
    }

    public CdoSnapshotState getState() {
        return this.state;
    }

    public boolean isInitial() {
        return this.type == SnapshotType.INITIAL;
    }

    public boolean isTerminal() {
        return this.type == SnapshotType.TERMINAL;
    }

    public SnapshotType getType() {
        return this.type;
    }
}

