/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import org.javers.common.collections.Objects;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;

class ValueChangeAppender
extends CorePropertyChangeAppender<ValueChange> {
    ValueChangeAppender() {
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof PrimitiveOrValueType;
    }

    @Override
    public ValueChange calculateChanges(NodePair pair, Property property) {
        Object leftValue = pair.getLeftPropertyValue(property);
        Object rightValue = pair.getRightPropertyValue(property);
        if (this.isIdProperty(pair, property) ? Objects.nullSafeEquals(ReflectionUtil.reflectiveToString(leftValue), ReflectionUtil.reflectiveToString(rightValue)) : Objects.nullSafeEquals(leftValue, rightValue)) {
            return null;
        }
        return new ValueChange(pair.getGlobalId(), property, leftValue, rightValue);
    }

    private boolean isIdProperty(NodePair nodePair, Property property) {
        GlobalId globalId = nodePair.getGlobalId();
        if (globalId instanceof InstanceId) {
            return ((InstanceId)globalId).getManagedType().getIdProperty().equals(property);
        }
        return false;
    }
}

