/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import java.util.ArrayList;
import java.util.List;
import org.javers.core.commit.CommitId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandedOutIds {
    private static final Logger logger = LoggerFactory.getLogger(HandedOutIds.class);
    private int limit = 5;
    private List<CommitId> handedOutList = new ArrayList<CommitId>();

    HandedOutIds() {
    }

    void put(CommitId handedOut) {
        int found;
        if (this.handedOutList.size() == this.limit) {
            this.handedOutList.remove(this.limit - 1);
        }
        if ((found = this.findIndex(handedOut.getMajorId())) < 0) {
            this.handedOutList.add(0, handedOut);
        } else {
            this.handedOutList.remove(found);
            this.handedOutList.add(found, handedOut);
        }
    }

    private int findIndex(Long majorId) {
        for (int i = 0; i < this.handedOutList.size(); ++i) {
            CommitId c = this.handedOutList.get(i);
            if (c.getMajorId() == majorId.longValue()) {
                return i;
            }
            if (c.getMajorId() >= majorId) continue;
            return -1;
        }
        return -1;
    }

    CommitId get(Long majorId) {
        for (CommitId id : this.handedOutList) {
            if (id.getMajorId() != majorId.longValue()) continue;
            return id;
        }
        return null;
    }
}

