/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.graph.ObjectAccessHook;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.repository.jql.GlobalIdDTO;

public class GlobalIdFactory {
    private final TypeMapper typeMapper;
    private ObjectAccessHook objectAccessHook;

    public GlobalIdFactory(TypeMapper typeMapper, ObjectAccessHook objectAccessHook) {
        this.typeMapper = typeMapper;
        this.objectAccessHook = objectAccessHook;
    }

    public GlobalId createId(Object targetCdo) {
        return this.createId(targetCdo, null);
    }

    public GlobalId createId(Object targetCdo, OwnerContext owner) {
        Validate.argumentsAreNotNull(targetCdo);
        targetCdo = this.objectAccessHook.access(targetCdo);
        ManagedType targetManagedType = this.typeMapper.getJaversManagedType(targetCdo.getClass());
        if (targetManagedType instanceof EntityType) {
            return InstanceId.createFromInstance(targetCdo, (EntityType)targetManagedType);
        }
        if (targetManagedType instanceof ValueObjectType && this.hasNoOwner(owner)) {
            return new UnboundedValueObjectId((ValueObjectType)targetManagedType);
        }
        if (targetManagedType instanceof ValueObjectType && this.hasOwner(owner)) {
            return new ValueObjectId((ValueObjectType)targetManagedType, owner);
        }
        throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
    }

    public UnboundedValueObjectId createFromClass(Class valueObjectClass) {
        ValueObjectType valueObject = this.typeMapper.getJaversManagedType(valueObjectClass, ValueObjectType.class);
        return new UnboundedValueObjectId(valueObject);
    }

    public ValueObjectId createFromPath(GlobalId owner, Class valueObjectClass, String path) {
        ValueObjectType valueObject = this.typeMapper.getJaversManagedType(valueObjectClass, ValueObjectType.class);
        return new ValueObjectId(valueObject, owner, path);
    }

    public InstanceId createFromId(Object localId, EntityType entity) {
        return InstanceId.createFromId(localId, entity);
    }

    public InstanceId createFromId(Object localId, Class entityClass) {
        EntityType entity = this.typeMapper.getJaversManagedType(entityClass, EntityType.class);
        return InstanceId.createFromId(localId, entity);
    }

    public GlobalId createFromDto(GlobalIdDTO idDto) {
        return idDto.create(this.typeMapper);
    }

    public Object dehydrate(Object item, JaversType targetType, OwnerContext context) {
        if (item == null) {
            return null;
        }
        if (!(item instanceof GlobalId) && targetType instanceof ManagedType) {
            return this.createId(item, context);
        }
        return item;
    }

    private boolean hasOwner(OwnerContext context) {
        return context != null && context.getGlobalId() != null;
    }

    private boolean hasNoOwner(OwnerContext context) {
        return context == null || context.getGlobalId() == null;
    }
}

