/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.List;
import org.javers.common.collections.Predicate;
import org.javers.common.string.PrettyPrintBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedClassFactory;

public abstract class ManagedType
extends JaversType {
    private final ManagedClass managedClass;

    ManagedType(ManagedClass managedClass) {
        super(managedClass.getClientsClass());
        Validate.argumentIsNotNull(managedClass);
        this.managedClass = managedClass;
    }

    ManagedClass getManagedClass() {
        return this.managedClass;
    }

    abstract ManagedType spawn(Class var1, ManagedClassFactory var2);

    @Override
    protected Type getRawDehydratedType() {
        return GlobalId.class;
    }

    @Override
    protected PrettyPrintBuilder prettyPrintBuilder() {
        return super.prettyPrintBuilder().addMultiField("managedProperties", this.managedClass.getProperties());
    }

    public Property getProperty(String propertyName) {
        return this.managedClass.getProperty(propertyName);
    }

    public List<Property> getProperties(Predicate<Property> query) {
        return this.managedClass.getProperties(query);
    }

    public List<Property> getProperties() {
        return this.managedClass.getProperties();
    }
}

