/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.string.PrettyPrintBuilder;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;

public abstract class JaversType {
    private final Type baseJavaType;
    private final Class baseJavaClass;
    private final List<Type> actualTypeArguments;

    JaversType(Type baseJavaType) {
        Validate.argumentIsNotNull(baseJavaType);
        this.baseJavaType = baseJavaType;
        this.baseJavaClass = ReflectionUtil.extractClass(baseJavaType);
        this.actualTypeArguments = ReflectionUtil.extractActualClassTypeArguments(baseJavaType);
    }

    JaversType spawn(Type baseJavaType) {
        try {
            Constructor<?> c = this.getClass().getConstructor(Type.class);
            return (JaversType)c.newInstance(baseJavaType);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("error calling Constructor for " + this.getClass().getName(), exception);
        }
    }

    public boolean isGenericType() {
        return this.baseJavaType instanceof ParameterizedType;
    }

    public Type getBaseJavaType() {
        return this.baseJavaType;
    }

    public Class getBaseJavaClass() {
        return this.baseJavaClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaversType that = (JaversType)o;
        return this.baseJavaType.equals(that.baseJavaType);
    }

    public String toString() {
        return ToStringBuilder.toString(this, "baseType", this.baseJavaType);
    }

    public int hashCode() {
        return this.baseJavaType.hashCode();
    }

    public List<Type> getActualTypeArguments() {
        return Collections.unmodifiableList(this.actualTypeArguments);
    }

    Type getRawDehydratedType() {
        return this.getBaseJavaClass();
    }

    public final String prettyPrint() {
        return this.prettyPrintBuilder().build();
    }

    public String getName() {
        return this.baseJavaClass.getName();
    }

    public boolean isInstance(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        return this.baseJavaClass.isAssignableFrom(cdo.getClass());
    }

    protected PrettyPrintBuilder prettyPrintBuilder() {
        return new PrettyPrintBuilder(this).addField("baseType", this.baseJavaType);
    }
}

