/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.CdoSnapshotStateBuilder;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.property.Property;

public class CdoSnapshotBuilder {
    private final GlobalId globalId;
    private CommitMetadata commitMetadata;
    private SnapshotType type = SnapshotType.UPDATE;
    private CdoSnapshotState state;
    private CdoSnapshotStateBuilder stateBuilder = CdoSnapshotStateBuilder.cdoSnapshotState();
    private CdoSnapshot previous;
    private boolean markAllAsChanged;
    private List<Property> changed = Collections.EMPTY_LIST;

    private CdoSnapshotBuilder(GlobalId globalId, CommitMetadata commitMetadata) {
        Validate.argumentsAreNotNull(globalId, commitMetadata);
        this.globalId = globalId;
        this.commitMetadata = commitMetadata;
    }

    public static CdoSnapshot emptyCopyOf(CdoSnapshot snapshot) {
        return CdoSnapshotBuilder.cdoSnapshot(snapshot.getGlobalId(), snapshot.getCommitMetadata()).withType(snapshot.getType()).build();
    }

    public static CdoSnapshotBuilder cdoSnapshot(GlobalId globalId, CommitMetadata commitMetadata) {
        return new CdoSnapshotBuilder(globalId, commitMetadata);
    }

    public CdoSnapshotBuilder withState(CdoSnapshotState state) {
        Validate.argumentIsNotNull(state);
        this.state = state;
        return this;
    }

    public CdoSnapshot build() {
        if (this.state == null) {
            this.state = this.stateBuilder.build();
        }
        if (this.previous != null) {
            this.changed = this.state.differentValues(this.previous.getState());
        }
        if (this.markAllAsChanged) {
            this.changed = new ArrayList<Property>(this.state.getProperties());
        }
        return new CdoSnapshot(this.globalId, this.commitMetadata, this.state, this.type, this.changed);
    }

    public CdoSnapshotBuilder withType(SnapshotType type) {
        Validate.argumentIsNotNull((Object)type);
        this.type = type;
        return this;
    }

    public CdoSnapshotBuilder withPropertyValue(Property property, Object value) {
        this.stateBuilder.withPropertyValue(property, value);
        return this;
    }

    @Deprecated
    public CdoSnapshotBuilder withInitial(boolean initial) {
        this.type = initial ? SnapshotType.INITIAL : SnapshotType.UPDATE;
        return this;
    }

    public CdoSnapshotBuilder markAllAsChanged() {
        this.markAllAsChanged = true;
        return this;
    }

    public CdoSnapshotBuilder withChangedProperties(List<String> changedPropertyNames) {
        this.changed = new ArrayList<Property>();
        for (String propertyName : changedPropertyNames) {
            this.changed.add(this.globalId.getManagedType().getProperty(propertyName));
        }
        return this;
    }

    public CdoSnapshotBuilder markChanged(CdoSnapshot previous) {
        this.previous = previous;
        return this;
    }
}

