/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import org.javers.common.validation.Validate;

public abstract class ClientsDomainClass {
    private final Class clientsClass;

    ClientsDomainClass(Class clientsClass) {
        Validate.argumentIsNotNull(clientsClass);
        this.clientsClass = clientsClass;
    }

    public Class getClientsClass() {
        return this.clientsClass;
    }

    public boolean isInstance(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        return this.clientsClass.isAssignableFrom(cdo.getClass());
    }

    public String getName() {
        return this.clientsClass.getName();
    }

    public String getSimpleName() {
        return this.getClass().getSimpleName();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClientsDomainClass)) {
            return false;
        }
        ClientsDomainClass that = (ClientsDomainClass)o;
        return this.clientsClass.equals(that.clientsClass);
    }

    public int hashCode() {
        return this.clientsClass.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getClientsClass().getSimpleName() + ")";
    }
}

