/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.lang.annotation.Annotation;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.AnnotationNamesProvider;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.clazz.ValueDefinition;
import org.javers.core.metamodel.clazz.ValueObjectDefinition;

public class ClassAnnotationsScanner {
    private final AnnotationNamesProvider annotationNamesProvider;

    public ClassAnnotationsScanner(AnnotationNamesProvider annotationNamesProvider) {
        this.annotationNamesProvider = annotationNamesProvider;
    }

    ClientsClassDefinition scanAndInfer(Class javaClass) {
        Validate.argumentIsNotNull(javaClass);
        for (Annotation ann : javaClass.getAnnotations()) {
            if (this.annotationNamesProvider.isEntityAlias(ann)) {
                return new EntityDefinition(javaClass);
            }
            if (this.annotationNamesProvider.isValueObjectAlias(ann)) {
                return new ValueObjectDefinition(javaClass);
            }
            if (!this.annotationNamesProvider.isValueAlias(ann)) continue;
            return new ValueDefinition(javaClass);
        }
        return new ValueObjectDefinition(javaClass);
    }
}

