/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.commit;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.CdoSnapshotStateBuilder;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.TypeMapper;

public class CdoSnapshotStateDeserializer {
    private final TypeMapper typeMapper;
    private final JsonDeserializationContext context;

    public CdoSnapshotStateDeserializer(TypeMapper typeMapper, JsonDeserializationContext context) {
        this.typeMapper = typeMapper;
        this.context = context;
    }

    public CdoSnapshotState deserialize(JsonElement stateElement, GlobalId globalId) {
        Validate.argumentsAreNotNull(stateElement, globalId, this.context);
        JsonObject stateObject = (JsonObject)stateElement;
        CdoSnapshotStateBuilder builder = CdoSnapshotStateBuilder.cdoSnapshotState();
        for (Property property : globalId.getCdoClass().getProperties()) {
            builder.withPropertyValue(property, this.decodePropertyValue(stateObject, this.context, property));
        }
        return builder.build();
    }

    private Object decodePropertyValue(JsonObject element, JsonDeserializationContext context, Property property) {
        JsonElement propertyElement = element.get(property.getName());
        Type dehydratedPropertyType = this.typeMapper.getDehydratedType(property.getGenericType());
        return context.deserialize(propertyElement, dehydratedPropertyType);
    }
}

