/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.json.GlobalIdRawDTO;
import org.javers.core.json.typeadapter.commit.CdoSnapshotStateDeserializer;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.type.TypeMapper;

public class JsonConverter {
    private Gson gson;
    private final CdoSnapshotStateDeserializer stateDeserializer;
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    JsonConverter(TypeMapper typeMapper, GlobalIdFactory globalIdFactory, Gson gson) {
        Validate.argumentsAreNotNull(typeMapper, gson);
        this.gson = gson;
        JsonDeserializationContext deserializationContext = new JsonDeserializationContext(){

            public <T> T deserialize(JsonElement json, Type typeOfT) throws JsonParseException {
                return (T)JsonConverter.this.fromJson(json, typeOfT);
            }
        };
        this.stateDeserializer = new CdoSnapshotStateDeserializer(typeMapper, deserializationContext);
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    public String toJson(Object value) {
        return this.gson.toJson(value);
    }

    public JsonElement toJsonElement(Object value) {
        return this.gson.toJsonTree(value);
    }

    public <T> T fromJson(String json, Class<T> expectedType) {
        return (T)this.gson.fromJson(json, expectedType);
    }

    public Object fromJson(String json, Type expectedType) {
        return this.gson.fromJson(json, expectedType);
    }

    public Object fromJson(JsonElement json, Type expectedType) {
        return this.gson.fromJson(json, expectedType);
    }

    public GlobalId fromDto(GlobalIdRawDTO globalIdDTO) {
        Validate.argumentIsNotNull(globalIdDTO);
        Class cdoClass = JsonConverter.parseClass(globalIdDTO.getCdoClassName());
        if (globalIdDTO.isInstanceId()) {
            Entity entity = this.typeMapper.getManagedClass(cdoClass, Entity.class);
            Object cdoId = this.fromJson(globalIdDTO.getLocalIdJSON(), entity.getIdProperty().getType());
            return this.globalIdFactory.createFromId(cdoId, entity);
        }
        if (globalIdDTO.isValueObjectId()) {
            GlobalId ownerId = this.fromDto(globalIdDTO.getOwnerId());
            return this.globalIdFactory.createFromPath(ownerId, cdoClass, globalIdDTO.getFragment());
        }
        return this.globalIdFactory.createFromClass(cdoClass);
    }

    public CdoSnapshotState snapshotStateFromJson(String json, GlobalId globalId) {
        Validate.argumentsAreNotNull(json, globalId);
        JsonElement stateElement = this.fromJson(json, JsonElement.class);
        return this.stateDeserializer.deserialize(stateElement, globalId);
    }

    public static Class parseClass(String qualifiedName) {
        try {
            return Class.forName(qualifiedName);
        }
        catch (ClassNotFoundException e) {
            throw new JaversException(JaversExceptionCode.CLASS_NOT_FOUND, qualifiedName);
        }
    }
}

