/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.HashMap;
import java.util.Map;
import org.javers.common.collections.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.exception.JaversGetterException;
import org.javers.common.validation.Validate;
import org.javers.core.graph.Edge;
import org.javers.core.graph.SingleEdge;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.clazz.ManagedClass;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.CdoWrapper;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.property.Property;

public class ObjectNode {
    private final Cdo cdo;
    private final Map<Property, Edge> edges = new HashMap<Property, Edge>();

    public ObjectNode(Cdo cdo) {
        Validate.argumentIsNotNull(cdo);
        this.cdo = cdo;
    }

    ObjectNode(Object cdo, Entity entity) {
        this(new CdoWrapper(cdo, InstanceId.createFromInstance(cdo, entity)));
    }

    public Optional<Object> wrappedCdo() {
        return this.cdo.getWrappedCdo();
    }

    public GlobalId getGlobalId() {
        return this.cdo.getGlobalId();
    }

    public GlobalId getReference(Property property) {
        Edge edge = this.getEdge(property);
        if (edge != null && edge instanceof SingleEdge) {
            return ((SingleEdge)edge).getReference().getGlobalId();
        }
        return (GlobalId)this.getPropertyValue(property);
    }

    public Object getPropertyValue(Property property) {
        Validate.argumentIsNotNull(property);
        try {
            return this.cdo.getPropertyValue(property);
        }
        catch (JaversGetterException e) {
            throw new JaversException(JaversExceptionCode.MISSING_PROPERTY, property.getName(), this.cdo.getManagedClass().getName());
        }
    }

    public boolean isNull(Property property) {
        Validate.argumentIsNotNull(property);
        return this.cdo.isNull(property);
    }

    Edge getEdge(Property property) {
        return this.edges.get(property);
    }

    Edge getEdge(String propertyName) {
        for (Property p : this.edges.keySet()) {
            if (!p.getName().equals(propertyName)) continue;
            return this.getEdge(p);
        }
        return null;
    }

    void addEdge(Edge edge) {
        this.edges.put(edge.getProperty(), edge);
    }

    int edgesCount() {
        return this.edges.size();
    }

    public ManagedClass getManagedClass() {
        return this.cdo.getManagedClass();
    }

    public Cdo getCdo() {
        return this.cdo;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectNode that = (ObjectNode)o;
        return this.cdo.equals(that.cdo);
    }

    public int hashCode() {
        return this.cdo.hashCode();
    }
}

