/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.object.GlobalId;

public class InstanceId
extends GlobalId {
    private final transient Entity entity;
    private final Object cdoId;

    private InstanceId(Object cdoId, Entity entity) {
        Validate.argumentsAreNotNull(cdoId, entity);
        this.entity = entity;
        this.cdoId = cdoId;
    }

    public static InstanceId createFromInstance(Object instance, Entity entity) {
        return new InstanceId(entity.getIdOf(instance), entity);
    }

    public static InstanceId createFromId(Object id, Entity entity) {
        return new InstanceId(id, entity);
    }

    @Override
    public Entity getCdoClass() {
        return this.entity;
    }

    @Override
    public Object getCdoId() {
        return this.cdoId;
    }

    @Override
    public String value() {
        return this.entity.getClientsClass().getName() + "/" + this.cdoId;
    }

    public boolean idEquals(Object instance) {
        if (instance == null) {
            return false;
        }
        if (!this.entity.getClientsClass().isAssignableFrom(instance.getClass())) {
            return false;
        }
        return this.cdoId.equals(this.entity.getIdOf(instance));
    }
}

