/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.javers.common.collections.Defaults;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.Property;

public class CdoSnapshotState {
    private final Map<Property, Object> properties;

    CdoSnapshotState(Map<Property, Object> state) {
        Validate.argumentIsNotNull(state);
        this.properties = state;
    }

    int size() {
        return this.properties.size();
    }

    public Object getPropertyValue(Property property) {
        Validate.argumentIsNotNull(property);
        Object val = this.properties.get(property);
        if (val == null) {
            return Defaults.defaultValue(property.getType());
        }
        return val;
    }

    boolean isNull(Property property) {
        Validate.argumentIsNotNull(property);
        return !this.properties.containsKey(property);
    }

    public Set<Property> getProperties() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CdoSnapshotState)) {
            return false;
        }
        CdoSnapshotState that = (CdoSnapshotState)o;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }
}

