/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import org.javers.common.collections.Optional;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.ClientsDomainClass;
import org.javers.core.metamodel.clazz.CustomDefinition;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.clazz.ManagedClassFactory;
import org.javers.core.metamodel.clazz.Value;
import org.javers.core.metamodel.clazz.ValueObject;
import org.javers.core.metamodel.type.CustomType;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(TypeFactory.class);
    private final ManagedClassFactory managedClassFactory;

    public TypeFactory(ManagedClassFactory managedClassFactory) {
        this.managedClassFactory = managedClassFactory;
    }

    JaversType createFromDefinition(ClientsClassDefinition def) {
        if (def instanceof CustomDefinition) {
            return new CustomType(def.getClazz());
        }
        return this.createFromClientsClass(this.managedClassFactory.create(def));
    }

    JaversType infer(Type javaType, Optional<JaversType> prototype) {
        JaversType jType;
        if (prototype.isPresent()) {
            jType = this.spawnFromPrototype(javaType, prototype.get());
            logger.info("javersType of [{}] inferred as {} from prototype {}", new Object[]{javaType, jType.getClass().getSimpleName(), prototype.get()});
        } else {
            jType = this.inferFromAnnotations(javaType);
            logger.info("javersType of [{}] inferred as {}", (Object)jType.getBaseJavaClass().getSimpleName(), (Object)jType.getClass().getSimpleName());
        }
        return jType;
    }

    JaversType inferIdPropertyTypeAsValue(EntityType eType) {
        Type idPropertyType = eType.getIdPropertyGenericType();
        logger.info("javersType of [{}] inferred as ValueType, it's used as id-property type in {}", (Object)idPropertyType, (Object)eType);
        return new ValueType(idPropertyType);
    }

    private JaversType spawnFromPrototype(Type javaType, JaversType prototype) {
        Validate.argumentsAreNotNull(javaType, prototype);
        Class javaClass = ReflectionUtil.extractClass(javaType);
        if (prototype instanceof ManagedType) {
            return ((ManagedType)prototype).spawn(javaClass, this.managedClassFactory);
        }
        return prototype.spawn(javaType);
    }

    private JaversType inferFromAnnotations(Type javaType) {
        Class javaClass = ReflectionUtil.extractClass(javaType);
        return this.createFromClientsClass(this.managedClassFactory.inferFromAnnotations(javaClass));
    }

    private JaversType createFromClientsClass(ClientsDomainClass clientsClass) {
        if (clientsClass instanceof Value) {
            return new ValueType(clientsClass.getClientsClass());
        }
        if (clientsClass instanceof ValueObject) {
            return new ValueObjectType((ValueObject)clientsClass);
        }
        if (clientsClass instanceof Entity) {
            return new EntityType((Entity)clientsClass);
        }
        throw new IllegalArgumentException("unsupported " + clientsClass.getName());
    }
}

