/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.collections.Defaults;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.collections.Objects;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotBuilder;
import org.javers.core.metamodel.object.DehydrateContainerFunction;
import org.javers.core.metamodel.object.DehydrateMapFunction;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.TypeMapper;

public class SnapshotFactory {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    public SnapshotFactory(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    CdoSnapshot create(Object liveCdo, GlobalId id, CommitMetadata commitMetadata) {
        return this.create(liveCdo, id, commitMetadata, SnapshotType.UPDATE);
    }

    CdoSnapshot create(Object liveCdo, GlobalId id, CommitMetadata commitMetadata, SnapshotType type) {
        CdoSnapshotBuilder snapshot = CdoSnapshotBuilder.cdoSnapshot(id, commitMetadata).withType(type);
        for (Property property : id.getCdoClass().getProperties()) {
            Object propertyVal = property.get(liveCdo);
            if (Objects.nullSafeEquals(propertyVal, Defaults.defaultValue(property.getType()))) continue;
            Object propertyType = this.typeMapper.getPropertyType(property);
            OwnerContext owner = new OwnerContext(id, property.getName());
            Object filteredPropertyVal = propertyType instanceof EnumerableType ? this.extractAndDehydrateEnumerable(propertyVal, (EnumerableType)propertyType, owner) : this.globalIdFactory.dehydrate(propertyVal, (JaversType)propertyType, owner);
            snapshot.withPropertyValue(property, filteredPropertyVal);
        }
        return snapshot.build();
    }

    public CdoSnapshot createTerminal(GlobalId globalId, CommitMetadata commitMetadata) {
        return CdoSnapshotBuilder.cdoSnapshot(globalId, commitMetadata).withType(SnapshotType.TERMINAL).build();
    }

    public CdoSnapshot createInitial(ObjectNode objectNode, CommitMetadata commitMetadata) {
        return this.create(objectNode.wrappedCdo().get(), objectNode.getGlobalId(), commitMetadata, SnapshotType.INITIAL);
    }

    public CdoSnapshot create(ObjectNode objectNode, CommitMetadata commitMetadata) {
        return this.create(objectNode.wrappedCdo().get(), objectNode.getGlobalId(), commitMetadata, SnapshotType.UPDATE);
    }

    private Object extractAndDehydrateEnumerable(Object propertyVal, EnumerableType propertyType, OwnerContext owner) {
        EnumerableFunction dehydratorMapFunction;
        if (!propertyType.isFullyParametrized()) {
            throw new JaversException(JaversExceptionCode.GENERIC_TYPE_NOT_PARAMETRIZED, propertyType.getBaseJavaType().toString());
        }
        if (propertyType instanceof ContainerType) {
            JaversType itemType = this.typeMapper.getJaversType(((ContainerType)propertyType).getItemClass());
            dehydratorMapFunction = new DehydrateContainerFunction(itemType, this.globalIdFactory);
        } else if (propertyType instanceof MapType) {
            dehydratorMapFunction = new DehydrateMapFunction((MapType)propertyType, this.typeMapper, this.globalIdFactory);
        } else {
            throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
        }
        return propertyType.map(propertyVal, dehydratorMapFunction, owner);
    }
}

