/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ArgumentResolver;
import org.javers.common.reflection.JaversField;
import org.javers.common.reflection.JaversFieldFactory;
import org.javers.common.reflection.JaversMethod;
import org.javers.common.reflection.JaversMethodFactory;
import org.javers.common.validation.Validate;

public class ReflectionUtil {
    public static Object newInstance(Class clazz, ArgumentResolver resolver) {
        Validate.argumentIsNotNull(clazz);
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (ReflectionUtil.isPrivate(constructor)) continue;
            Class<?>[] types = constructor.getParameterTypes();
            Object[] params = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                params[i] = resolver.resolve(types[i]);
            }
            try {
                constructor.setAccessible(true);
                return constructor.newInstance(params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new JaversException(JaversExceptionCode.NO_PUBLIC_CONSTRUCTOR, clazz.getName());
    }

    public static List<JaversField> getAllPersistentFields(Class methodSource) {
        ArrayList<JaversField> result = new ArrayList<JaversField>();
        for (JaversField field : ReflectionUtil.getAllFields(methodSource)) {
            if (!ReflectionUtil.isPersistentField((Field)field.getRawMember())) continue;
            result.add(field);
        }
        return result;
    }

    public static List<JaversMethod> findAllPersistentGetters(Class methodSource) {
        ArrayList<JaversMethod> result = new ArrayList<JaversMethod>();
        for (JaversMethod m : ReflectionUtil.getAllMethods(methodSource)) {
            if (!ReflectionUtil.isPersistentGetter((Method)m.getRawMember())) continue;
            result.add(m);
        }
        return result;
    }

    public static List<JaversMethod> getAllMethods(Class methodSource) {
        JaversMethodFactory methodFactory = new JaversMethodFactory(methodSource);
        return methodFactory.getAllMethods();
    }

    public static List<JaversField> getAllFields(Class<?> methodSource) {
        JaversFieldFactory fieldFactory = new JaversFieldFactory(methodSource);
        return fieldFactory.getAllFields();
    }

    public static boolean isPersistentGetter(Method m) {
        if (!ReflectionUtil.isGetter(m)) {
            return false;
        }
        return !Modifier.isStatic(m.getModifiers()) && !Modifier.isAbstract(m.getModifiers()) && !Modifier.isNative(m.getModifiers());
    }

    public static boolean isPersistentField(Field field) {
        return !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers()) && !field.getName().equals("this$0");
    }

    public static boolean isGetter(Method m) {
        return (m.getName().substring(0, 3).equals("get") || m.getName().substring(0, 2).equals("is")) && m.getParameterTypes().length == 0;
    }

    private static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static List<Class> extractActualClassTypeArguments(Type javaType) {
        if (!(javaType instanceof ParameterizedType)) {
            return Collections.emptyList();
        }
        ParameterizedType parameterizedType = (ParameterizedType)javaType;
        ArrayList<Class> result = new ArrayList<Class>();
        for (Type t : parameterizedType.getActualTypeArguments()) {
            if (!(t instanceof Class)) continue;
            result.add((Class)t);
        }
        return Collections.unmodifiableList(result);
    }

    public static Class extractClass(Type javaType) {
        if (javaType instanceof ParameterizedType && ((ParameterizedType)javaType).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)javaType).getRawType();
        }
        if (javaType instanceof Class) {
            return (Class)javaType;
        }
        throw new JaversException(JaversExceptionCode.CLASS_EXTRACTION_ERROR, javaType);
    }

    public static int calculateHierarchyDistance(Class<?> clazz, Class<?> parent) {
        Class<?> current = clazz;
        int distance = 0;
        while (current != null) {
            if (parent == current) {
                return distance;
            }
            for (Class<?> interf : current.getInterfaces()) {
                if (parent != interf) continue;
                return distance + 1;
            }
            current = current.getSuperclass();
            ++distance;
        }
        return Integer.MAX_VALUE;
    }
}

