/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.ArrayList;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.snapshot.ShadowGraph;
import org.javers.core.snapshot.SnapshotFactory;
import org.javers.repository.api.JaversExtendedRepository;

public class GraphSnapshotFactory {
    private final SnapshotFactory snapshotFactory;
    private final JaversExtendedRepository javersRepository;

    public GraphSnapshotFactory(SnapshotFactory snapshotFactory, JaversExtendedRepository javersRepository) {
        this.snapshotFactory = snapshotFactory;
        this.javersRepository = javersRepository;
    }

    public List<CdoSnapshot> create(LiveGraph currentVersion, ShadowGraph latestShadowGraph, CommitMetadata commitMetadata) {
        Validate.argumentsAreNotNull(currentVersion, commitMetadata, latestShadowGraph);
        ArrayList<CdoSnapshot> reused = new ArrayList<CdoSnapshot>();
        for (ObjectNode node : currentVersion.nodes()) {
            boolean initial;
            CdoSnapshot fresh = this.snapshotFactory.create(node, commitMetadata, initial = this.isInitial(node, latestShadowGraph));
            Optional<CdoSnapshot> existing = this.javersRepository.getLatest(fresh.getGlobalId());
            if (existing.isEmpty()) {
                reused.add(fresh);
                continue;
            }
            if (existing.get().stateEquals(fresh)) continue;
            reused.add(fresh);
        }
        return reused;
    }

    List<CdoSnapshot> create(LiveGraph currentVersion, CommitMetadata commitMetadata) {
        return this.create(currentVersion, ShadowGraph.EMPTY, commitMetadata);
    }

    private boolean isInitial(ObjectNode node, ShadowGraph latestShadowGraph) {
        return !latestShadowGraph.nodes().contains(node);
    }
}

