/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javers.core.metamodel.clazz.AnnotationsNameSpace;

public class AnnotationNamesProvider {
    private final List<AnnotationsNameSpace> namesProviders;
    private final Set<String> entityAliases = new HashSet<String>();
    private final Set<String> valueObjectAliases = new HashSet<String>();
    private final Set<String> valueAliases = new HashSet<String>();
    private final Set<String> transientPropertyAliases = new HashSet<String>();

    public AnnotationNamesProvider(List<AnnotationsNameSpace> namesProviders) {
        this.namesProviders = namesProviders;
        for (AnnotationsNameSpace provider : namesProviders) {
            this.entityAliases.addAll(provider.getEntityAliases());
            this.valueObjectAliases.addAll(provider.getValueObjectAliases());
            this.valueAliases.addAll(provider.getValueAliases());
            this.transientPropertyAliases.addAll(provider.getTransientPropertyAliases());
        }
    }

    boolean isEntityAlias(Annotation ann) {
        return this.entityAliases.contains(ann.annotationType().getSimpleName());
    }

    boolean isValueObjectAlias(Annotation ann) {
        return this.valueObjectAliases.contains(ann.annotationType().getSimpleName());
    }

    boolean isValueAlias(Annotation ann) {
        return this.valueAliases.contains(ann.annotationType().getSimpleName());
    }

    public Set<String> getTransientAliases() {
        return Collections.unmodifiableSet(this.transientPropertyAliases);
    }
}

