/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.common.collections.Optional;
import org.javers.common.collections.Primitives;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.clazz.ManagedClass;
import org.javers.core.metamodel.clazz.ValueObject;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.DistancePair;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.TypeFactory;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMapper {
    private static final Logger logger = LoggerFactory.getLogger(TypeMapper.class);
    private final ValueType OBJECT_TYPE = new ValueType((Type)((Object)Object.class));
    private final TypeFactory typeFactory;
    private final Map<Type, JaversType> mappedTypes;

    public TypeMapper(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.mappedTypes = new HashMap<Type, JaversType>();
        for (Class<?> primitiveOrBox : Primitives.getPrimitiveAndBoxTypes()) {
            this.registerPrimitiveType(primitiveOrBox);
        }
        this.registerPrimitiveType(String.class);
        this.registerPrimitiveType(Enum.class);
        this.addType(new ArrayType((Type)((Object)Object[].class)));
        this.registerValueType(LocalDateTime.class);
        this.registerValueType(LocalDate.class);
        this.registerValueType(BigDecimal.class);
        this.registerValueType(Date.class);
        this.addType(new SetType((Type)((Object)Set.class)));
        this.addType(new ListType((Type)((Object)List.class)));
        this.addType(new MapType((Type)((Object)Map.class)));
    }

    public JaversType getJaversType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        if (javaType == Object.class) {
            return this.OBJECT_TYPE;
        }
        JaversType jType = this.getExactMatchingJaversType(javaType);
        if (jType != null) {
            return jType;
        }
        return this.infer(javaType);
    }

    public ManagedType getJaversManagedType(Class javaType) {
        JaversType javersType = this.getJaversType(javaType);
        if (!(javersType instanceof ManagedType)) {
            throw new JaversException(JaversExceptionCode.CLASS_NOT_MANAGED, javaType.getName(), javersType.getClass().getSimpleName());
        }
        return (ManagedType)javersType;
    }

    public <T extends JaversType> T getPropertyType(Property property) {
        Validate.argumentIsNotNull(property);
        return (T)this.getJaversType(property.getGenericType());
    }

    public boolean isEntityReferenceOrValueObject(Property property) {
        Object javersType = this.getPropertyType(property);
        return javersType instanceof ManagedType;
    }

    public boolean isContainerOfManagedClasses(JaversType javersType) {
        if (!(javersType instanceof ContainerType)) {
            return false;
        }
        return this.getJaversType(((ContainerType)javersType).getItemClass()) instanceof ManagedType;
    }

    public boolean isMapWithManagedClass(EnumerableType enumerableType) {
        if (!(enumerableType instanceof MapType)) {
            return false;
        }
        MapType mapType = (MapType)enumerableType;
        JaversType keyType = this.getJaversType(mapType.getKeyClass());
        JaversType valueType = this.getJaversType(mapType.getValueClass());
        return keyType instanceof ManagedType || valueType instanceof ManagedType;
    }

    private void registerPrimitiveType(Class<?> primitiveClass) {
        this.addType(new PrimitiveType(primitiveClass));
    }

    public void registerClientsClass(ClientsClassDefinition def) {
        this.addType(this.typeFactory.createFromDefinition(def));
    }

    public void registerValueType(Class<?> valueCLass) {
        this.addType(new ValueType(valueCLass));
    }

    protected <T extends JaversType> List<T> getMappedTypes(Class<T> ofType) {
        ArrayList<JaversType> result = new ArrayList<JaversType>();
        for (JaversType jType : this.mappedTypes.values()) {
            if (!ofType.isAssignableFrom(jType.getClass())) continue;
            result.add(jType);
        }
        return result;
    }

    public boolean isValueObject(Class clazz) {
        JaversType jType = this.getJaversType(clazz);
        return jType instanceof ValueObjectType;
    }

    public Class getDehydratedType(Class expectedType) {
        JaversType expectedJaversType = this.getJaversType(expectedType);
        if (expectedJaversType instanceof ManagedType) {
            return GlobalId.class;
        }
        return expectedType;
    }

    public <T extends ManagedClass> T getManagedClass(Class javaClass, Class<T> expectedType) {
        ManagedType mType = this.getJaversManagedType(javaClass);
        if (mType.getManagedClass().getClass().equals(expectedType)) {
            return (T)mType.getManagedClass();
        }
        throw new JaversException(JaversExceptionCode.MANAGED_CLASS_MAPPING_ERROR, javaClass, mType.getManagedClass().getSimpleName(), expectedType.getSimpleName());
    }

    public ValueObject getChildValueObject(Entity owner, String voPropertyName) {
        JaversType contentType;
        JaversType javersType = this.getJaversType(owner.getProperty(voPropertyName).getGenericType());
        if (javersType instanceof ValueObjectType) {
            return ((ValueObjectType)javersType).getManagedClass();
        }
        if (javersType instanceof ContainerType && (contentType = this.getJaversType(((ContainerType)javersType).getItemClass())) instanceof ValueObjectType) {
            return ((ValueObjectType)contentType).getManagedClass();
        }
        throw new JaversException(JaversExceptionCode.CANNOT_EXTRACT_CHILD_VALUE_OBJECT, owner.getName() + "." + voPropertyName, javersType);
    }

    private boolean isContainerOfValueObjects(JaversType javersType) {
        if (!(javersType instanceof ContainerType)) {
            return false;
        }
        return this.getJaversType(((ContainerType)javersType).getItemClass()) instanceof ValueObjectType;
    }

    private void addType(JaversType jType) {
        this.mappedTypes.put(jType.getBaseJavaType(), jType);
        if (jType instanceof EntityType) {
            this.inferIdPropertyTypeAsValue((EntityType)jType);
        }
    }

    private JaversType getExactMatchingJaversType(Type javaType) {
        return this.mappedTypes.get(javaType);
    }

    private JaversType infer(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        JaversType prototype = this.findNearestAncestor(javaType);
        JaversType newType = this.typeFactory.infer(javaType, Optional.fromNullable(prototype));
        this.addType(newType);
        return newType;
    }

    private void inferIdPropertyTypeAsValue(EntityType eType) {
        Validate.argumentIsNotNull(eType);
        if (!this.isMapped(eType.getIdPropertyGenericType())) {
            this.addType(this.typeFactory.inferIdPropertyTypeAsValue(eType));
        }
    }

    private boolean isMapped(Type javaType) {
        return this.mappedTypes.containsKey(javaType);
    }

    private JaversType findNearestAncestor(Type javaType) {
        Class javaClass = ReflectionUtil.extractClass(javaType);
        ArrayList<DistancePair> distances = new ArrayList<DistancePair>();
        for (JaversType javersType : this.mappedTypes.values()) {
            DistancePair distancePair = new DistancePair(javaClass, javersType);
            if (javaClass.isArray()) {
                return this.getJaversType((Type)((Object)Object[].class));
            }
            if (distancePair.getDistance() == 1) {
                return distancePair.getJaversType();
            }
            distances.add(distancePair);
        }
        Collections.sort(distances);
        if (((DistancePair)distances.get(0)).isMax()) {
            return null;
        }
        return ((DistancePair)distances.get(0)).getJaversType();
    }
}

