/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.core.graph.LiveCdoFactory;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.ObjectGraphBuilder;
import org.javers.core.metamodel.type.TypeMapper;

public class LiveGraphFactory {
    private final TypeMapper typeMapper;
    private final LiveCdoFactory liveCdoFactory;

    public LiveGraphFactory(TypeMapper typeMapper, LiveCdoFactory liveCdoFactory) {
        this.typeMapper = typeMapper;
        this.liveCdoFactory = liveCdoFactory;
    }

    public LiveGraph createLiveGraph(Object handle) {
        Object wrappedHandle = this.wrapTopLevelContainer(handle);
        return new ObjectGraphBuilder(this.typeMapper, this.liveCdoFactory).buildGraph(wrappedHandle);
    }

    private Object wrapTopLevelContainer(Object handle) {
        if (handle instanceof Map) {
            return new MapWrapper((Map)handle);
        }
        if (handle instanceof List) {
            return new ListWrapper((List)handle);
        }
        if (handle instanceof Set) {
            return new SetWrapper((Set)handle);
        }
        return handle;
    }

    public static Class getMapWrapperType() {
        return MapWrapper.class;
    }

    public static Class getSetWrapperType() {
        return SetWrapper.class;
    }

    public static Class getListWrapperType() {
        return ListWrapper.class;
    }

    private class ListWrapper {
        private final List<Object> list;

        public ListWrapper(List list) {
            this.list = list;
        }
    }

    private class SetWrapper {
        private final Set<Object> set;

        private SetWrapper(Set set) {
            this.set = set;
        }
    }

    private class MapWrapper {
        private final Map<Object, Object> map;

        private MapWrapper(Map map) {
            this.map = map;
        }
    }
}

