/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.date.DateProvider;
import org.javers.common.validation.Validate;
import org.javers.core.GraphFactory;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.commit.CommitSeqGenerator;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.graph.LiveGraph;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.snapshot.ShadowGraph;
import org.javers.repository.api.JaversExtendedRepository;

public class CommitFactory {
    private final DiffFactory diffFactory;
    private final JaversExtendedRepository javersRepository;
    private final GraphFactory graphFactory;
    private final CommitSeqGenerator commitSeqGenerator;
    private final DateProvider dateProvider;

    public CommitFactory(DiffFactory diffFactory, JaversExtendedRepository javersRepository, GraphFactory graphFactory, CommitSeqGenerator commitSeqGenerator, DateProvider dateProvider) {
        this.diffFactory = diffFactory;
        this.javersRepository = javersRepository;
        this.graphFactory = graphFactory;
        this.commitSeqGenerator = commitSeqGenerator;
        this.dateProvider = dateProvider;
    }

    public Commit create(String author, Object currentVersion) {
        Validate.argumentsAreNotNull(author, currentVersion);
        CommitId head = this.javersRepository.getHeadId();
        CommitId newId = this.commitSeqGenerator.nextId(head);
        LiveGraph currentGraph = this.graphFactory.createLiveGraph(currentVersion);
        ShadowGraph latestShadowGraph = this.graphFactory.createLatestShadow(currentGraph);
        CommitMetadata commitMetadata = new CommitMetadata(author, this.dateProvider.now(), newId);
        List<CdoSnapshot> snapshots = this.graphFactory.createGraphSnapshot(currentGraph, latestShadowGraph, commitMetadata);
        Diff diff = this.diffFactory.create(latestShadowGraph, currentGraph, Optional.of(commitMetadata));
        return new Commit(commitMetadata, snapshots, diff);
    }
}

