/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.metamodel.clazz.AnnotationNamesProvider;
import org.javers.core.metamodel.property.BeanProperty;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.property.PropertyScanner;

public class BeanBasedPropertyScanner
implements PropertyScanner {
    private final AnnotationNamesProvider annotationNamesProvider;

    public BeanBasedPropertyScanner(AnnotationNamesProvider annotationNamesProvider) {
        this.annotationNamesProvider = annotationNamesProvider;
    }

    @Override
    public List<Property> scan(Class<?> managedClass) {
        List<Method> getters = ReflectionUtil.findAllPersistentGetters(managedClass);
        ArrayList<Property> beanProperties = new ArrayList<Property>();
        for (Method getter : getters) {
            if (ReflectionUtil.hasAnyAnnotation(getter, this.annotationNamesProvider.getTransientAliases())) continue;
            BeanProperty beanProperty = new BeanProperty(getter);
            beanProperties.add(beanProperty);
        }
        return beanProperties;
    }
}

