/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.change;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.HashMap;
import java.util.Map;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.ReferenceChange;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.diff.changetype.container.ArrayChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.diff.changetype.map.MapChange;
import org.javers.core.json.JsonTypeAdapterTemplate;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;

public class ChangeTypeAdapter<T extends Change>
extends JsonTypeAdapterTemplate<T> {
    private static final String CHANGE_TYPE_FIELD = "changeType";
    private static final String AFFECTED_CDO_ID_FIELD = "globalId";
    private static final String PROPERTY_FIELD = "property";
    private static final String COMMIT_METADATA = "commitMetadata";
    private Map<String, Class<? extends Change>> changeTypeMap = new HashMap<String, Class<? extends Change>>();

    public ChangeTypeAdapter() {
        this.initEntry(ValueChange.class);
        this.initEntry(ReferenceChange.class);
        this.initEntry(NewObject.class);
        this.initEntry(ObjectRemoved.class);
        this.initEntry(MapChange.class);
        this.initEntry(ListChange.class);
        this.initEntry(ArrayChange.class);
        this.initEntry(SetChange.class);
    }

    protected T appendCommitMetadata(JsonObject jsonObject, JsonDeserializationContext context, T change) {
        if (jsonObject.has(COMMIT_METADATA)) {
            CommitMetadata commitMetadata = (CommitMetadata)context.deserialize(jsonObject.get(COMMIT_METADATA), CommitMetadata.class);
            ((Change)change).bindToCommit(commitMetadata);
        }
        return change;
    }

    @Override
    public T fromJson(JsonElement json, JsonDeserializationContext context) {
        JsonObject jsonObject = (JsonObject)json;
        String changeTypeField = jsonObject.get(CHANGE_TYPE_FIELD).getAsString();
        Class<Change> changeType = this.decode(changeTypeField);
        return (T)((Change)context.deserialize(json, changeType));
    }

    @Override
    public JsonElement toJson(T change, JsonSerializationContext context) {
        return this.createJsonObject(change, context);
    }

    protected PropertyChangeStub deserializeStub(JsonObject jsonObject, JsonDeserializationContext context) {
        GlobalId id = this.deserializeAffectedCdoId(jsonObject, context);
        Property property = this.deserializeProperty(jsonObject, id);
        return new PropertyChangeStub(id, property);
    }

    protected GlobalId deserializeAffectedCdoId(JsonObject jsonObject, JsonDeserializationContext context) {
        return (GlobalId)context.deserialize(jsonObject.get(AFFECTED_CDO_ID_FIELD), GlobalId.class);
    }

    private Property deserializeProperty(JsonObject jsonObject, GlobalId id) {
        String propertyName = jsonObject.get(PROPERTY_FIELD).getAsString();
        return id.getCdoClass().getProperty(propertyName);
    }

    protected JsonObject createJsonObject(T change, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(CHANGE_TYPE_FIELD, this.encode(change.getClass()));
        jsonObject.add(AFFECTED_CDO_ID_FIELD, context.serialize((Object)((Change)change).getAffectedGlobalId()));
        if (((Change)change).getCommitMetadata().isPresent()) {
            jsonObject.add(COMMIT_METADATA, context.serialize((Object)((Change)change).getCommitMetadata().get()));
        }
        if (change instanceof PropertyChange) {
            jsonObject.addProperty(PROPERTY_FIELD, ((PropertyChange)change).getProperty().getName());
        }
        return jsonObject;
    }

    @Override
    public Class getValueType() {
        return Change.class;
    }

    private void initEntry(Class<? extends Change> valueChangeClass) {
        this.changeTypeMap.put(this.encode(valueChangeClass), valueChangeClass);
    }

    private String encode(Class<? extends Change> valueChangeClass) {
        return valueChangeClass.getSimpleName();
    }

    private Class<? extends Change> decode(String changeType) {
        if (!this.changeTypeMap.containsKey(changeType)) {
            throw new JaversException(JaversExceptionCode.MALFORMED_CHANGE_TYPE_FIELD, changeType);
        }
        return this.changeTypeMap.get(changeType);
    }

    protected class PropertyChangeStub {
        GlobalId id;
        Property property;

        PropertyChangeStub(GlobalId id, Property property) {
            this.id = id;
            this.property = property;
        }
    }
}

