/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import com.google.gson.TypeAdapter;
import java.util.HashSet;
import java.util.Set;
import org.javers.common.pico.JaversModule;
import org.javers.common.validation.Validate;
import org.javers.core.AbstractJaversBuilder;
import org.javers.core.Javers;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.MappingStyle;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.JsonConverterBuilder;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.json.typeadapter.CdoSnapshotTypeAdapter;
import org.javers.core.json.typeadapter.CommitIdTypeAdapter;
import org.javers.core.json.typeadapter.GlobalIdTypeAdapter;
import org.javers.core.json.typeadapter.InstanceIdDTOTypeAdapter;
import org.javers.core.json.typeadapter.change.ArrayChangeTypeAdapter;
import org.javers.core.json.typeadapter.change.ListChangeTypeAdapter;
import org.javers.core.json.typeadapter.change.MapChangeTypeAdapter;
import org.javers.core.json.typeadapter.change.SetChangeTypeAdapter;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.property.EntityDefinition;
import org.javers.core.metamodel.property.ManagedClassDefinition;
import org.javers.core.metamodel.property.ValueDefinition;
import org.javers.core.metamodel.property.ValueObjectDefinition;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.pico.CoreJaversModule;
import org.javers.core.pico.ManagedClassFactoryModule;
import org.javers.repository.api.InMemoryRepository;
import org.javers.repository.api.JaversRepository;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversBuilder
extends AbstractJaversBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JaversBuilder.class);
    private static final Class<? extends JsonTypeAdapter>[] DOMAIN_AWARE_ADAPTERS = new Class[]{GlobalIdTypeAdapter.class, MapChangeTypeAdapter.class, ArrayChangeTypeAdapter.class, ListChangeTypeAdapter.class, SetChangeTypeAdapter.class, CdoSnapshotTypeAdapter.class, CommitIdTypeAdapter.class, InstanceIdDTOTypeAdapter.class};
    private final Set<ManagedClassDefinition> managedClassDefinitions = new HashSet<ManagedClassDefinition>();
    private JaversRepository repository;

    private JaversBuilder() {
        logger.debug("starting up javers ...");
        this.bootContainer((JaversModule)new CoreJaversModule(), new Object[0]);
    }

    public static JaversBuilder javers() {
        return new JaversBuilder();
    }

    public Javers build() {
        this.bootManagedClasses();
        this.bootJsonConverter();
        this.bootRepository();
        logger.info("javers instance is up & ready");
        return this.getContainerComponent(Javers.class);
    }

    public JaversBuilder registerJaversRepository(JaversRepository repository) {
        Validate.argumentsAreNotNull(repository);
        this.repository = repository;
        return this;
    }

    public JaversBuilder registerEntity(Class<?> entityClass) {
        Validate.argumentIsNotNull(entityClass);
        return this.registerEntity(new EntityDefinition(entityClass));
    }

    public JaversBuilder registerEntity(Class<?> entityClass, String idPropertyName) {
        Validate.argumentsAreNotNull(entityClass, idPropertyName);
        return this.registerEntity(new EntityDefinition(entityClass, idPropertyName));
    }

    private JaversBuilder registerEntity(EntityDefinition entityDefinition) {
        this.managedClassDefinitions.add(entityDefinition);
        return this;
    }

    public JaversBuilder registerValueObject(Class<?> valueObjectClass) {
        Validate.argumentIsNotNull(valueObjectClass);
        this.managedClassDefinitions.add(new ValueObjectDefinition(valueObjectClass));
        return this;
    }

    public JaversBuilder registerValueObjects(Class<?> ... valueObjectClasses) {
        for (Class<?> clazz : valueObjectClasses) {
            this.registerValueObject(clazz);
        }
        return this;
    }

    @Override
    PicoContainer bootContainer(JaversModule module, Object ... beans) {
        return super.bootContainer(module, beans);
    }

    public JaversBuilder registerValue(Class<?> valueClass) {
        Validate.argumentIsNotNull(valueClass);
        this.managedClassDefinitions.add(new ValueDefinition(valueClass));
        return this;
    }

    public JaversBuilder registerValueTypeAdapter(JsonTypeAdapter typeAdapter) {
        for (Class c : typeAdapter.getValueTypes()) {
            this.registerValue(c);
        }
        this.jsonConverterBuilder().registerJsonTypeAdapter(typeAdapter);
        return this;
    }

    public JaversBuilder registerValueGsonTypeAdapter(Class valueType, TypeAdapter nativeAdapter) {
        this.registerValue(valueType);
        this.jsonConverterBuilder().registerNativeTypeAdapter(valueType, nativeAdapter);
        return this;
    }

    public JaversBuilder typeSafeValues() {
        this.jsonConverterBuilder().typeSafeValues(true);
        return this;
    }

    public JaversBuilder registerEntities(Class<?> ... entityClasses) {
        for (Class<?> clazz : entityClasses) {
            this.registerEntity(clazz);
        }
        return this;
    }

    public JaversBuilder withMappingStyle(MappingStyle mappingStyle) {
        Validate.argumentIsNotNull((Object)mappingStyle);
        this.coreConfiguration().withMappingStyle(mappingStyle);
        return this;
    }

    public JaversBuilder withNewObjectsSnapshot(boolean newObjectsSnapshot) {
        this.coreConfiguration().withNewObjectsSnapshot(newObjectsSnapshot);
        return this;
    }

    private void mapRegisteredClasses() {
        TypeMapper typeMapper = this.typeMapper();
        for (ManagedClassDefinition def : this.managedClassDefinitions) {
            typeMapper.registerManagedClass(def);
        }
    }

    private TypeMapper typeMapper() {
        return this.getContainerComponent(TypeMapper.class);
    }

    private JaversCoreConfiguration coreConfiguration() {
        return this.getContainerComponent(JaversCoreConfiguration.class);
    }

    private JsonConverterBuilder jsonConverterBuilder() {
        return this.getContainerComponent(JsonConverterBuilder.class);
    }

    private void bootManagedClasses() {
        this.addModule(new ManagedClassFactoryModule(this.coreConfiguration()));
        this.mapRegisteredClasses();
    }

    private void bootJsonConverter() {
        JsonConverterBuilder jsonConverterBuilder = this.jsonConverterBuilder();
        for (Class<? extends JsonTypeAdapter> adapter : DOMAIN_AWARE_ADAPTERS) {
            jsonConverterBuilder.registerJsonTypeAdapter(this.getContainerComponent(adapter));
        }
        this.addComponent(jsonConverterBuilder.build());
    }

    private void bootRepository() {
        if (this.repository == null) {
            logger.info("using fake InMemoryRepository, register actual implementation via JaversBuilder.registerJaversRepository()");
            this.repository = new InMemoryRepository(this.getContainerComponent(GlobalIdFactory.class));
        }
        this.addComponent(this.repository);
        this.repository.setJsonConverter(this.getContainerComponent(JsonConverter.class));
    }
}

