/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.Entity;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.ManagedClassDefinition;
import org.javers.core.metamodel.property.ManagedClassFactory;
import org.javers.core.metamodel.property.ValueDefinition;
import org.javers.core.metamodel.property.ValueObject;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;

public class TypeFactory {
    private final ManagedClassFactory managedClassFactory;

    public TypeFactory(ManagedClassFactory managedClassFactory) {
        this.managedClassFactory = managedClassFactory;
    }

    JaversType createFromDefinition(ManagedClassDefinition def) {
        if (def instanceof ValueDefinition) {
            return new ValueType(def.getClazz());
        }
        ManagedClass managedClass = this.managedClassFactory.create(def);
        return this.createFromManagedClass(managedClass);
    }

    JaversType spawnFromPrototype(Type javaType, JaversType prototype) {
        Validate.argumentsAreNotNull(javaType, prototype);
        Class javaClass = ReflectionUtil.extractClass(javaType);
        if (prototype instanceof ManagedType) {
            return ((ManagedType)prototype).spawn(javaClass, this.managedClassFactory);
        }
        return prototype.spawn(javaType);
    }

    public JaversType infer(Type javaType) {
        Class javaClass = ReflectionUtil.extractClass(javaType);
        ManagedClass managedClass = this.managedClassFactory.infer(javaClass);
        return this.createFromManagedClass(managedClass);
    }

    private JaversType createFromManagedClass(ManagedClass managedClass) {
        if (managedClass instanceof ValueObject) {
            return new ValueObjectType((ValueObject)managedClass);
        }
        if (managedClass instanceof Entity) {
            return new EntityType((Entity)managedClass);
        }
        throw new IllegalArgumentException("unsupported " + managedClass);
    }
}

