/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.Maps;
import org.javers.common.collections.Objects;
import org.javers.common.validation.Validate;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.map.EntryAdded;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.diff.changetype.map.EntryRemoved;
import org.javers.core.diff.changetype.map.EntryValueChange;
import org.javers.core.diff.changetype.map.MapChange;
import org.javers.core.metamodel.object.DehydrateMapFunction;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.TypeMapper;

public class MapChangeAppender
extends PropertyChangeAppender<MapChange> {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    public MapChangeAppender(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        Validate.argumentsAreNotNull(typeMapper, globalIdFactory);
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    protected boolean supports(JaversType propertyType) {
        return propertyType instanceof MapType;
    }

    @Override
    protected MapChange calculateChanges(NodePair pair, Property property) {
        OwnerContext owner;
        Map leftRawMap = (Map)pair.getLeftPropertyValue(property);
        Map rightRawMap = (Map)pair.getRightPropertyValue(property);
        MapType mapType = (MapType)this.typeMapper.getPropertyType(property);
        List<EntryChange> changes = this.calculateEntryChanges(mapType, leftRawMap, rightRawMap, owner = new OwnerContext(pair.getGlobalId(), property.getName()));
        if (!changes.isEmpty()) {
            return new MapChange(pair.getGlobalId(), property, changes);
        }
        return null;
    }

    List<EntryChange> calculateEntryChanges(MapType mapType, Map leftRawMap, Map rightRawMap, OwnerContext owner) {
        Map rightMap;
        DehydrateMapFunction dehydrateFunction = new DehydrateMapFunction(mapType, this.typeMapper, this.globalIdFactory);
        Map leftMap = mapType.map(leftRawMap, dehydrateFunction, owner);
        if (Objects.nullSafeEquals(leftMap, rightMap = mapType.map(rightRawMap, dehydrateFunction, owner))) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EntryChange> changes = new ArrayList<EntryChange>();
        for (Object commonKey : Maps.commonKeys(leftMap, rightMap)) {
            Object rightVal;
            Object leftVal = leftMap.get(commonKey);
            if (Objects.nullSafeEquals(leftVal, rightVal = rightMap.get(commonKey))) continue;
            changes.add(new EntryValueChange(commonKey, leftVal, rightVal));
        }
        for (Object addedKey : Maps.keysDifference(rightMap, leftMap)) {
            Object addedValue = rightMap.get(addedKey);
            changes.add(new EntryAdded(addedKey, addedValue));
        }
        for (Object removedKey : Maps.keysDifference(leftMap, rightMap)) {
            Object removedValue = leftMap.get(removedKey);
            changes.add(new EntryRemoved(removedKey, removedValue));
        }
        return changes;
    }
}

