/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.common.validation.Validate;

public class PropertiesUtil {
    public static String getStringProperty(Properties properties, String propertyKey) {
        Validate.argumentIsNotNull(properties);
        Validate.argumentIsNotNull(propertyKey);
        if (!properties.containsKey(propertyKey)) {
            throw new JaversException(JaversExceptionCode.UNDEFINED_PROPERTY, propertyKey);
        }
        return properties.getProperty(propertyKey);
    }

    public static boolean getBooleanProperty(Properties properties, String propertyKey) {
        String val = PropertiesUtil.getStringProperty(properties, propertyKey);
        return Boolean.parseBoolean(val);
    }

    public static <T extends Enum<T>> T getEnumProperty(Properties properties, String propertyKey, Class<T> enumType) {
        String enumName = PropertiesUtil.getStringProperty(properties, propertyKey);
        Validate.argumentIsNotNull(enumType);
        try {
            return Enum.valueOf(enumType, enumName);
        }
        catch (IllegalArgumentException e) {
            throw new JaversException(JaversExceptionCode.MALFORMED_PROPERTY, enumName, propertyKey);
        }
    }

    public static Properties getProperties(String classpathName) {
        Properties properties = new Properties();
        PropertiesUtil.loadProperties(classpathName, properties);
        return properties;
    }

    public static void loadProperties(String classpathName, Properties toProps) {
        Validate.argumentIsNotNull(classpathName);
        Validate.argumentIsNotNull(toProps);
        InputStream inputStream = PropertiesUtil.class.getClassLoader().getResourceAsStream(classpathName);
        if (inputStream == null) {
            throw new JaversException(JaversExceptionCode.CLASSPATH_RESOURCE_NOT_FOUND, classpathName);
        }
        try {
            toProps.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

