/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.HashSet;
import org.javers.common.collections.Optional;
import org.javers.common.collections.Sets;
import org.javers.common.validation.Validate;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.snapshot.ShadowGraph;
import org.javers.repository.api.JaversExtendedRepository;

public class GraphShadowFactory {
    private final JaversExtendedRepository javersRepository;

    public GraphShadowFactory(JaversExtendedRepository javersRepository) {
        this.javersRepository = javersRepository;
    }

    public ShadowGraph createLatestShadow(LiveGraph liveGraph) {
        Validate.argumentIsNotNull(liveGraph);
        HashSet<ObjectNode> snapshotNodes = new HashSet<ObjectNode>();
        for (ObjectNode liveNode : liveGraph.flatten()) {
            Optional<CdoSnapshot> snapshot = this.javersRepository.getLatest(liveNode.getGlobalCdoId());
            if (snapshot.isEmpty()) continue;
            snapshotNodes.add(new ObjectNode(snapshot.get()));
        }
        return new ShadowGraph(snapshotNodes);
    }

    public ShadowGraph createFromSnapshot(CdoSnapshot cdoSnapshot) {
        return new ShadowGraph(Sets.asSet(new ObjectNode(cdoSnapshot)));
    }
}

