/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.pico;

import java.util.List;
import java.util.Properties;
import org.javers.common.pico.JaversModule;
import org.javers.common.validation.Validate;
import org.picocontainer.Characteristics;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;

public class JaversContainerFactory {
    public static MutablePicoContainer create(List<JaversModule> modules, List<?> beans) {
        Validate.argumentIsNotNull(modules);
        DefaultPicoContainer container = new DefaultPicoContainer();
        for (JaversModule module : modules) {
            JaversContainerFactory.addModule((MutablePicoContainer)container, module);
        }
        if (beans != null) {
            for (JaversModule bean : beans) {
                JaversContainerFactory.addComponent((MutablePicoContainer)container, bean);
            }
        }
        return container;
    }

    public static void addModule(MutablePicoContainer container, JaversModule module) {
        for (Class component : module.getModuleComponents()) {
            JaversContainerFactory.addComponent(container, component);
        }
    }

    public static void addComponent(MutablePicoContainer container, Object classOrInstance) {
        container.as(new Properties[]{Characteristics.CACHE}).addComponent(classOrInstance);
    }
}

