/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.HashMap;
import java.util.Map;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.property.Property;

public class CdoSnapshotBuilder {
    private final GlobalCdoId globalCdoId;
    private final Map<Property, Object> state = new HashMap<Property, Object>();
    private CommitMetadata commitMetadata;

    private CdoSnapshotBuilder(GlobalCdoId globalCdoId, CommitMetadata commitMetadata) {
        this.globalCdoId = globalCdoId;
        this.commitMetadata = commitMetadata;
    }

    public static CdoSnapshotBuilder cdoSnapshot(GlobalCdoId globalCdoId, CommitMetadata commitMetadata) {
        Validate.argumentIsNotNull(globalCdoId);
        return new CdoSnapshotBuilder(globalCdoId, commitMetadata);
    }

    public CdoSnapshotBuilder withPropertyValue(Property property, Object value) {
        Validate.argumentIsNotNull(property);
        if (value == null) {
            return this;
        }
        if (this.state.containsKey(property)) {
            throw new JaversException(JaversExceptionCode.SNAPSHOT_STATE_VIOLATION, new Object[0]);
        }
        this.state.put(property, value);
        return this;
    }

    public CdoSnapshot build() {
        return new CdoSnapshot(this.globalCdoId, this.commitMetadata, this.state);
    }

    public CdoSnapshotBuilder withCommitMetadata(CommitMetadata commitMetadata) {
        this.commitMetadata = commitMetadata;
        return this;
    }
}

