/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.util.List;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.Property;

public class Entity
extends ManagedClass {
    private final Property idProperty;

    public Entity(Class sourceClass, List<Property> properties, Property idProperty) {
        super(sourceClass, properties);
        this.idProperty = idProperty == null ? this.findDefaultIdProperty() : idProperty;
    }

    private Property findDefaultIdProperty() {
        for (Property p : this.getProperties()) {
            if (!p.looksLikeId()) continue;
            return p;
        }
        throw new JaversException(JaversExceptionCode.ENTITY_WITHOUT_ID, this.getName());
    }

    public Object getIdOf(Object instance) {
        Validate.argumentIsNotNull(instance);
        if (!this.getSourceClass().isInstance(instance)) {
            throw new JaversException(JaversExceptionCode.NOT_INSTANCE_OF, this.getName(), instance.getClass().getName());
        }
        Validate.argumentCheck(this.getSourceClass().isInstance(instance), "expected instance of " + this.getSourceClass().getName() + ", got instance of " + instance.getClass().getName());
        Object cdoId = this.getIdProperty().get(instance);
        if (cdoId == null) {
            throw new JaversException(JaversExceptionCode.ENTITY_INSTANCE_WITH_NULL_ID, this.getName());
        }
        return cdoId;
    }

    public Property getIdProperty() {
        return this.idProperty;
    }
}

