/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.persistence.Id;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.Property;

public class BeanProperty
implements Property {
    private final transient Method getter;
    private final String name;

    BeanProperty(Method getter) {
        Validate.argumentIsNotNull(getter, "getter should not be null!");
        this.getter = getter;
        this.name = ReflectionUtil.getterToField(getter);
    }

    @Override
    public Type getGenericType() {
        return this.getter.getGenericReturnType();
    }

    @Override
    public Class<?> getType() {
        return this.getter.getReturnType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object get(Object target) {
        return ReflectionUtil.invokeGetterEvenIfPrivate(this.getter, target);
    }

    @Override
    public boolean isNull(Object target) {
        return this.get(target) == null;
    }

    @Override
    public boolean looksLikeId() {
        return this.getter.isAnnotationPresent(Id.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanProperty that = (BeanProperty)o;
        return this.getter.equals(that.getter);
    }

    public int hashCode() {
        return this.getter.hashCode();
    }

    public String toString() {
        return this.getter.getDeclaringClass().getSimpleName() + "." + this.getter.getName() + "()";
    }
}

