/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.property.Entity;

public class InstanceId
extends GlobalCdoId {
    private final transient Entity entity;
    private final Object cdoId;

    public InstanceId(Object instance, Entity entity) {
        Validate.argumentsAreNotNull(instance, entity);
        this.entity = entity;
        this.cdoId = entity.getIdOf(instance);
    }

    @Override
    public Entity getCdoClass() {
        return this.entity;
    }

    @Override
    public Object getCdoId() {
        return this.cdoId;
    }

    public String toString() {
        return this.entity.getSourceClass().getName() + "/" + this.cdoId;
    }

    public boolean idEquals(Object instance) {
        if (instance == null) {
            return false;
        }
        if (!this.entity.getSourceClass().isAssignableFrom(instance.getClass())) {
            return false;
        }
        return this.cdoId.equals(this.entity.getIdOf(instance));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof InstanceId)) {
            return false;
        }
        InstanceId other = (InstanceId)o;
        return this.entity.equals(other.entity) && this.cdoId.equals(other.cdoId);
    }

    public int hashCode() {
        return this.entity.hashCode() + this.cdoId.hashCode();
    }
}

