/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.ArrayList;
import java.util.Set;
import org.javers.common.collections.Collections;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.ContainerValueChange;
import org.javers.core.diff.changetype.ElementAdded;
import org.javers.core.diff.changetype.ElementRemoved;
import org.javers.core.diff.changetype.SetChange;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetChangeAppender
extends PropertyChangeAppender<SetChange> {
    private static final Logger logger = LoggerFactory.getLogger(SetChangeAppender.class);
    private final TypeMapper typeMapper;

    public SetChangeAppender(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    @Override
    protected Class<? extends JaversType> getSupportedPropertyType() {
        return SetType.class;
    }

    @Override
    protected boolean supports(JaversType propertyType) {
        if (!super.supports(propertyType)) {
            return false;
        }
        boolean isSupported = this.typeMapper.isSupportedContainer((SetType)propertyType);
        if (!isSupported) {
            logger.warn("unsupported set content type [{}], skipping", (Object)propertyType.getBaseJavaType());
        }
        return isSupported;
    }

    @Override
    protected SetChange calculateChanges(NodePair pair, Property property) {
        Set leftValues = (Set)pair.getLeftPropertyValue(property);
        Set rightValues = (Set)pair.getRightPropertyValue(property);
        ArrayList<ContainerValueChange> changes = new ArrayList<ContainerValueChange>();
        for (Object addedValue : Collections.difference(rightValues, leftValues)) {
            changes.add(new ElementAdded(addedValue));
        }
        for (Object addedValue : Collections.difference(leftValues, rightValues)) {
            changes.add(new ElementRemoved(addedValue));
        }
        if (changes.isEmpty()) {
            return null;
        }
        return new SetChange(pair.getGlobalCdoId(), property, changes);
    }
}

