/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.Collections;
import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.core.diff.DFSGraphToSetConverter;
import org.javers.model.object.graph.ObjectNode;

public class GraphPair {
    private final Set<ObjectNode> leftNodeSet;
    private final Set<ObjectNode> rightNodeSet;
    private final Set<ObjectNode> onlyOnLeft;
    private final Set<ObjectNode> onlyOnRight;
    private final DFSGraphToSetConverter graphToSetConverter = new DFSGraphToSetConverter();

    public GraphPair(ObjectNode leftRoot, ObjectNode rightRoot) {
        this.leftNodeSet = this.flatten(leftRoot);
        this.rightNodeSet = this.flatten(rightRoot);
        this.onlyOnLeft = Sets.difference(this.leftNodeSet, this.rightNodeSet);
        this.onlyOnRight = Sets.difference(this.rightNodeSet, this.leftNodeSet);
    }

    public GraphPair(ObjectNode root) {
        this.leftNodeSet = Collections.EMPTY_SET;
        this.rightNodeSet = this.flatten(root);
        this.onlyOnLeft = Collections.EMPTY_SET;
        this.onlyOnRight = Sets.difference(this.rightNodeSet, this.leftNodeSet);
    }

    public Set<ObjectNode> getOnlyOnLeft() {
        return this.onlyOnLeft;
    }

    public Set<ObjectNode> getOnlyOnRight() {
        return this.onlyOnRight;
    }

    public Set<ObjectNode> getLeftNodeSet() {
        return this.leftNodeSet;
    }

    public Set<ObjectNode> getRightNodeSet() {
        return this.rightNodeSet;
    }

    private Set<ObjectNode> flatten(ObjectNode leftRoot) {
        return this.graphToSetConverter.convertFromGraph(leftRoot);
    }
}

