/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.model.object.graph.ObjectGraphBuilder;

public class Javers {
    private final DiffFactory diffFactory;
    private final TypeMapper typeMapper;
    private final JsonConverter jsonConverter;

    public Javers(DiffFactory diffFactory, TypeMapper typeMapper, JsonConverter jsonConverter) {
        this.diffFactory = diffFactory;
        this.typeMapper = typeMapper;
        this.jsonConverter = jsonConverter;
    }

    public Diff initial(String user, Object root) {
        ObjectGraphBuilder graph = new ObjectGraphBuilder(this.typeMapper);
        return this.diffFactory.createInitial(user, graph.buildGraph(root));
    }

    public Diff compare(String user, Object left, Object right) {
        ObjectGraphBuilder leftGraph = new ObjectGraphBuilder(this.typeMapper);
        ObjectGraphBuilder rightGraph = new ObjectGraphBuilder(this.typeMapper);
        return this.diffFactory.create(user, leftGraph.buildGraph(left), rightGraph.buildGraph(right));
    }

    public String toJson(Diff diff) {
        return this.jsonConverter.toJson(diff);
    }

    JaversType getForClass(Class<?> clazz) {
        return this.typeMapper.getJaversType(clazz);
    }
}

