/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.properties;

import java.util.Properties;
import org.javers.common.properties.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PropertyConfiguration.class);
    private final Properties properties;

    public PropertyConfiguration(String classpathName) {
        logger.info("reading properties file - " + classpathName);
        this.properties = PropertiesUtil.getProperties(classpathName);
    }

    public <T extends Enum<T>> T getEnumProperty(String propertyKey, Class<T> enumType) {
        return PropertiesUtil.getEnumProperty(this.properties, propertyKey, enumType);
    }

    public boolean contains(String propertyKey) {
        return this.properties.containsKey(propertyKey);
    }

    public String getStringProperty(String propertyKey) {
        return PropertiesUtil.getStringProperty(this.properties, propertyKey);
    }
}

