/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.common.collections.Primitives;
import org.javers.common.validation.Validate;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.core.metamodel.property.Entity;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.property.ValueObject;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMapper {
    private static final Logger logger = LoggerFactory.getLogger(TypeMapper.class);
    private Map<Type, JaversType> mappedTypes = new HashMap<Type, JaversType>();

    public TypeMapper() {
        for (Class<?> primitiveOrBox : Primitives.getPrimitiveAndBoxTypes()) {
            this.registerPrimitiveType(primitiveOrBox);
        }
        this.registerPrimitiveType(String.class);
        this.registerPrimitiveType(Enum.class);
        this.addType(new ArrayType((Type)((Object)Object[].class)));
        this.registerValueType(LocalDateTime.class);
        this.registerValueType(BigDecimal.class);
        this.registerValueType(Date.class);
        this.addType(new CollectionType((Type)((Object)Set.class)));
        this.addType(new CollectionType((Type)((Object)List.class)));
        this.addType(new MapType((Type)((Object)Map.class)));
    }

    public JaversType getJaversType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        JaversType jType = this.getExactMatchingJaversType(javaType);
        if (jType != null) {
            return jType;
        }
        return this.spawnFromPrototype(javaType);
    }

    public ManagedClass getManagedClass(Class javaClass) {
        JaversType jType = this.getJaversType(javaClass);
        if (jType instanceof ManagedType) {
            return ((ManagedType)jType).getManagedClass();
        }
        throw new IllegalArgumentException("getManagedClass(" + javaClass.getSimpleName() + ") " + "given javaClass is mapped to " + jType.getClass().getSimpleName() + ", ManagedType expected");
    }

    public JaversType getPropertyType(Property property) {
        return this.getJaversType(property.getGenericType());
    }

    public boolean isEntityReferenceOrValueObject(Property property) {
        JaversType javersType = this.getPropertyType(property);
        return javersType instanceof EntityType || javersType instanceof ValueObjectType;
    }

    public boolean isSupportedMap(MapType propertyType) {
        if (propertyType.getEntryClass() == null) {
            return false;
        }
        return this.isPrimitiveOrValueOrObject(propertyType.getEntryClass().getKey()) && this.isPrimitiveOrValueOrObject(propertyType.getEntryClass().getValue());
    }

    public boolean isCollectionOfEntityReferences(Property property) {
        JaversType javersType = this.getPropertyType(property);
        if (!(javersType instanceof CollectionType)) {
            return false;
        }
        CollectionType collectionType = (CollectionType)javersType;
        if (collectionType.getElementType() == null) {
            return false;
        }
        JaversType elementType = this.getJaversType(collectionType.getElementType());
        return elementType instanceof EntityType;
    }

    public <T extends Collection> void registerCollectionType(Class<T> collectionType) {
        this.addType(new CollectionType(collectionType));
    }

    public void registerPrimitiveType(Class<?> primitiveClass) {
        this.addType(new PrimitiveType(primitiveClass));
    }

    public void registerValueObjectType(ValueObject valueObject) {
        this.addType(new ValueObjectType(valueObject));
    }

    public void registerEntityType(Entity entity) {
        this.addType(new EntityType(entity));
    }

    public void registerValueType(Class<?> objectValue) {
        this.addType(new ValueType(objectValue));
    }

    public <T extends JaversType> List<T> getMappedTypes(Class<T> ofType) {
        ArrayList<JaversType> result = new ArrayList<JaversType>();
        for (JaversType jType : this.mappedTypes.values()) {
            if (!ofType.isAssignableFrom(jType.getClass())) continue;
            result.add(jType);
        }
        return result;
    }

    private boolean isPrimitiveOrValueOrObject(Class clazz) {
        if (clazz == Object.class) {
            return true;
        }
        JaversType jType = this.getJaversType(clazz);
        return jType instanceof PrimitiveOrValueType || jType instanceof PrimitiveOrValueType;
    }

    private void addType(JaversType jType) {
        this.mappedTypes.put(jType.getBaseJavaType(), jType);
    }

    private JaversType getExactMatchingJaversType(Type javaType) {
        return this.mappedTypes.get(javaType);
    }

    private boolean isMapped(Type javaType) {
        return this.mappedTypes.containsKey(javaType);
    }

    private JaversType spawnFromPrototype(Type javaType) {
        JaversType prototype = this.findPrototypeAssignableFrom(javaType);
        JaversType spawned = prototype.spawn(javaType);
        this.addType(spawned);
        return spawned;
    }

    private JaversType findPrototypeAssignableFrom(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        for (JaversType javersType : this.mappedTypes.values()) {
            if (!javersType.mayBePrototypeFor(javaType)) continue;
            return javersType;
        }
        throw new JaversException(JaversExceptionCode.TYPE_NOT_MAPPED, javaType);
    }
}

