/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping.type;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;

public abstract class JaversType {
    private final Type baseJavaType;
    private final Class baseJavaClass;
    private final List<Class> actualClassTypeArguments;

    protected JaversType(Type baseJavaType) {
        Validate.argumentIsNotNull(baseJavaType);
        this.baseJavaType = baseJavaType;
        this.baseJavaClass = ReflectionUtil.extractClass(baseJavaType);
        this.actualClassTypeArguments = ReflectionUtil.extractActualClassTypeArguments(baseJavaType);
    }

    protected JaversType spawn(Type baseJavaType) {
        try {
            Constructor<?> c = this.getClass().getConstructor(Type.class);
            return (JaversType)c.newInstance(baseJavaType);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("error calling Constructor " + this.getClass().getSimpleName(), exception);
        }
    }

    public boolean isAssignableFrom(Class javaClass) {
        return this.baseJavaClass.isAssignableFrom(javaClass);
    }

    protected boolean isGenericType() {
        return this.baseJavaType instanceof ParameterizedType;
    }

    protected List<Class> getActualClassTypeArguments() {
        return this.actualClassTypeArguments;
    }

    public Type getBaseJavaType() {
        return this.baseJavaType;
    }

    protected Class getBaseJavaClass() {
        return this.baseJavaClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaversType that = (JaversType)o;
        return this.baseJavaType.equals(that.baseJavaType);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(type:" + this.baseJavaType + ")";
    }

    public int hashCode() {
        return this.baseJavaType.hashCode();
    }

    boolean mayBePrototypeFor(Type javaType) {
        return !this.isGenericType() && this.isAssignableFrom(ReflectionUtil.extractClass(javaType));
    }
}

