/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.core.metamodel.property.Entity;
import org.javers.core.metamodel.property.EntityDefinition;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.property.PropertyScanner;
import org.javers.core.metamodel.property.ValueObject;
import org.javers.core.metamodel.property.ValueObjectDefinition;

public class ManagedClassFactory {
    private PropertyScanner propertyScanner;

    public ManagedClassFactory(PropertyScanner propertyScanner) {
        Validate.argumentIsNotNull(propertyScanner);
        this.propertyScanner = propertyScanner;
    }

    public <S> Entity create(Class<S> clazz) {
        return this.create(new EntityDefinition(clazz));
    }

    public Entity create(EntityDefinition entityDefinition) {
        List<Property> properties = this.propertyScanner.scan(entityDefinition.getClazz());
        Property idProperty = null;
        if (entityDefinition.hasCustomId()) {
            idProperty = this.findIdPropertyByName(properties, entityDefinition);
        }
        return new Entity(entityDefinition.getClazz(), properties, idProperty);
    }

    private Property findIdPropertyByName(List<Property> beanProperties, EntityDefinition entityDefinition) {
        for (Property property : beanProperties) {
            if (!property.getName().equals(entityDefinition.getIdPropertyName())) continue;
            return property;
        }
        throw new JaversException(JaversExceptionCode.PROPERTY_NOT_FOUND, entityDefinition.getIdPropertyName(), entityDefinition.getClazz().getName());
    }

    public ValueObject create(ValueObjectDefinition valueObjectDefinition) {
        List<Property> properties = this.propertyScanner.scan(valueObjectDefinition.getClazz());
        return new ValueObject(valueObjectDefinition.getClazz(), properties);
    }
}

