/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import com.google.gson.TypeAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javers.common.pico.JaversModule;
import org.javers.common.validation.Validate;
import org.javers.core.AbstractJaversBuilder;
import org.javers.core.Javers;
import org.javers.core.MappingStyle;
import org.javers.core.configuration.JaversCoreConfiguration;
import org.javers.core.json.JsonConverterBuilder;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.metamodel.property.EntityDefinition;
import org.javers.core.metamodel.property.EntityManager;
import org.javers.core.metamodel.property.ManagedClassDefinition;
import org.javers.core.metamodel.property.ValueObjectDefinition;
import org.javers.core.pico.CoreJaversModule;
import org.javers.core.pico.ModelJaversModule;
import org.javers.model.mapping.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversBuilder
extends AbstractJaversBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JaversBuilder.class);
    private Set<ManagedClassDefinition> managedClassDefinitions = new HashSet<ManagedClassDefinition>();
    private List<JaversModule> externalModules = new ArrayList<JaversModule>();

    private JaversBuilder() {
        logger.debug("starting up javers ...");
        this.bootContainer((JaversModule)new CoreJaversModule(), new Object[0]);
    }

    public static JaversBuilder javers() {
        return new JaversBuilder();
    }

    public Javers build() {
        this.bootJsonConverter();
        this.addModule(new ModelJaversModule(this.coreConfiguration()));
        this.registerManagedClasses();
        this.bootEntityManager();
        logger.info("javers instance is up & ready");
        return this.getContainerComponent(Javers.class);
    }

    public JaversBuilder registerEntity(Class<?> entityClass) {
        Validate.argumentIsNotNull(entityClass);
        return this.registerEntity(new EntityDefinition(entityClass));
    }

    public JaversBuilder registerEntity(Class<?> entityClass, String idPropertyName) {
        Validate.argumentsAreNotNull(entityClass, idPropertyName);
        return this.registerEntity(new EntityDefinition(entityClass, idPropertyName));
    }

    private JaversBuilder registerEntity(EntityDefinition entityDefinition) {
        this.managedClassDefinitions.add(entityDefinition);
        this.typeMapper().registerEntityReferenceType(entityDefinition.getClazz());
        return this;
    }

    public JaversBuilder registerValueObject(Class<?> valueObjectClass) {
        Validate.argumentIsNotNull(valueObjectClass);
        this.managedClassDefinitions.add(new ValueObjectDefinition(valueObjectClass));
        this.typeMapper().registerValueObjectType(valueObjectClass);
        return this;
    }

    public JaversBuilder registerValueObjects(Class<?> ... valueObjectClasses) {
        for (Class<?> clazz : valueObjectClasses) {
            this.registerValueObject(clazz);
        }
        return this;
    }

    public JaversBuilder registerValue(Class<?> valueClass) {
        Validate.argumentIsNotNull(valueClass);
        this.typeMapper().registerValueType(valueClass);
        return this;
    }

    public JaversBuilder registerValueTypeAdapter(JsonTypeAdapter typeAdapter) {
        this.registerValue(typeAdapter.getValueType());
        this.jsonConverterBuilder().registerJsonTypeAdapter(typeAdapter);
        return this;
    }

    public JaversBuilder registerValueGsonTypeAdapter(Class valueType, TypeAdapter nativeAdapter) {
        this.registerValue(valueType);
        this.jsonConverterBuilder().registerNativeTypeAdapter(valueType, nativeAdapter);
        return this;
    }

    public JaversBuilder typeSafeValues() {
        this.jsonConverterBuilder().typeSafeValues(true);
        return this;
    }

    public JaversBuilder registerEntities(Class<?> ... entityClasses) {
        for (Class<?> clazz : entityClasses) {
            this.registerEntity(clazz);
        }
        return this;
    }

    public JaversBuilder withMappingStyle(MappingStyle mappingStyle) {
        this.coreConfiguration().withMappingStyle(mappingStyle);
        return this;
    }

    private void registerManagedClasses() {
        EntityManager entityManager = this.entityManager();
        for (ManagedClassDefinition def : this.managedClassDefinitions) {
            entityManager.register(def);
        }
    }

    private EntityManager entityManager() {
        return this.getContainerComponent(EntityManager.class);
    }

    private TypeMapper typeMapper() {
        return this.getContainerComponent(TypeMapper.class);
    }

    private JaversCoreConfiguration coreConfiguration() {
        return this.getContainerComponent(JaversCoreConfiguration.class);
    }

    private JsonConverterBuilder jsonConverterBuilder() {
        return this.getContainerComponent(JsonConverterBuilder.class);
    }

    private void bootEntityManager() {
        this.entityManager().buildManagedClasses();
    }

    private void bootJsonConverter() {
        this.addComponent(this.jsonConverterBuilder().build());
    }
}

